# 2. Prerequisites

Before we get into coding like a bunch of cybersecurity wizard, let’s make sure you have everything you need to succeed in this experiment. Just like a chef needs the right ingredients before they cook up something delicious, you’ll need the right tools and setup to cook up some sneaky (but totally ethical) malware.

So let’s go over what you need to get started!

---

## 1. Basic Knowledge

Don’t worry, you don’t need to be a hacker in a hoodie (yet!) to follow along with this experiment. Here’s a quick checklist of what you should know beforehand:

### **Programming Basics**:
- **Languages**: You should be familiar with **C** or **Python**, but don’t stress if you’re not a pro. We’ll guide you through everything. Just be comfy with basic syntax, loops, and functions.
- **Assembly Language**: We’ll dabble a bit in low-level **assembly** code when modifying the malware, but you don’t need to be an expert—just know that it exists, and that it’s what computers understand directly. Think of it as speaking robot.

### **Command Line Basics**:
- Be ready to work in the **terminal** (or Command Prompt if you’re on Windows). You’ll be typing out some commands to generate and manipulate the malware. If you've ever used `cd`, `ls`, or `mkdir`, you're good to go. If not, don’t worry—we’ll show you the ropes!

### **Basic Cybersecurity Concepts**:
- If you’ve ever heard of **viruses, malware, or antivirus software**, you’ve already got a head start! Knowing what these terms mean will help you understand the purpose of the experiment, but we’ll explain them along the way, too. No need to memorize fancy definitions!

---

## 2. Tools You’ll Need

Now it’s time to stock up your toolbox. You’ll need a few key pieces of software to carry out the experiment. Don’t worry, we’ve got links to all the good stuff!

### **Python** (optional but helpful):
- Python makes scripting and automation a breeze, so having it installed will help if you want to automate parts of the process or modify malware behavior with ease. Download it [here](https://www.python.org/downloads/).
- Verify that it’s installed by running this in your terminal:
  ```bash
  python --version
  ```

### **msfvenom**:
- This tool is a malware generator (sounds scary, right?) that we’ll use to create our basic shellcode. It’s part of the **Metasploit** framework. Don’t worry—you’re using it for good!
- You can install it along with the full Metasploit framework by following the official instructions [here](https://docs.metasploit.com/docs/using-metasploit/getting-started/nightly-installers.html).

### **A Text Editor or IDE**:
- You’ll need something to write and edit code. If you already have a favorite (like **VS Code**, **Sublime Text**, or even **Notepad++**), you’re all set. Otherwise, grab [VS Code](https://code.visualstudio.com/), which is super beginner-friendly!

### **Virtual Machine (VM)**:
- Since we’re dealing with malware, we need a safe environment to test it. Running the malware on your own computer directly is a no-no 🚫 (unless you want to deal with the digital equivalent of a fire-breathing dragon 🐉). A **Virtual Machine (VM)** is a safe way to test malware without messing up your actual computer.
- We recommend **VirtualBox** (free!) or **VMware**. Download and install VirtualBox [here](https://www.virtualbox.org/).

### **Antivirus Software**:
- In this experiment, we’ll be testing how well our obfuscated malware can evade antivirus detection. You’ll need an antivirus program installed inside your virtual machine. Some of the popular ones you can use are:
  - **Kaspersky** (used in this experiment).
  - **Windows Defender** (comes with Windows).
  - **Bitdefender**, **Avast**, etc.

  You can install antivirus software in your virtual machine and test how sneaky our malware becomes.

### **Access to VirusTotal and VirusScan**:
- **VirusTotal** and **VirusScan** are online services that use multiple antivirus engines to scan your files. We’ll submit our malware here to see how many antivirus programs can detect it.
  - Check out **VirusTotal** [here](https://www.virustotal.com/).
  - Visit **VirusScan** [here](https://www.virusscan.com/).

---

## 3. Setting Up Your Environment

Okay, so now you’ve got the tools—let’s talk about setting up your work environment. The key here is to create a safe space for experimenting with malware. We don’t want to accidentally infect your laptop and turn it into a glorified paperweight.

### Step-by-Step Setup for a Virtual Machine:

1. **Download and Install VirtualBox**:
   - Head over to the [VirtualBox website](https://www.virtualbox.org/) and download the latest version for your operating system (Windows, macOS, Linux).
   - Install VirtualBox following the instructions. Easy peasy.

2. **Download a Virtual Machine Image**:
   - We recommend using **Windows** for this experiment since a lot of antivirus software is geared toward it. You can download Windows virtual images [here](https://developer.microsoft.com/en-us/microsoft-edge/tools/vms/). It’s free to use for testing purposes!
   
3. **Install Your Virtual Machine**:
   - Open VirtualBox, click **New**, and follow the steps to install the Windows virtual image.
   - Allocate enough memory (at least 4 GB of RAM) and some storage (20 GB or so should be fine).

4. **Install Your Antivirus Software**:
   - Inside the virtual machine, download and install your antivirus software of choice (Kaspersky, Windows Defender, etc.).
   - Make sure it's up to date with the latest virus definitions so it can properly detect modern threats.

5. **Prepare the Virtual Machine for Testing**:
   - Isolate the VM from your network for extra safety. You don’t want malware escaping!
   - Disable shared folders, clipboard sharing, and network connections to make sure nothing spreads outside the VM.

---

## 4. Optional Tools

### **IDEs for Assembly**:
- If you're feeling fancy and want to dive deep into **assembly language**, tools like **IDA Pro** or **OllyDbg** are great for reverse-engineering and viewing assembly code.

### **Logging Tools**:
- Want to monitor how your malware behaves when it runs? Tools like **Procmon** (Process Monitor) from Sysinternals can help you see what’s going on under the hood. You can download it [here](https://docs.microsoft.com/en-us/sysinternals/downloads/procmon).

---

## 5. Ready to Roll?

That’s it—you’re ready to get started! Make sure you’ve got all the tools installed, your virtual machine is set up and locked down, and your antivirus is standing by, ready to try and catch our sneaky malware.

In the next section, we’ll walk through how to generate and modify our malware, step by step.
